﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

//CarPartsManager is a singleton class that handles all the car parts for each class of car
public class CarPartsManager : MonoBehaviour
{
    //The parts for each class
    public CarsClassParts LowEndParts { get; private set; }
    public CarsClassParts MediumEndParts { get; private set; }
    public CarsClassParts HighEndParts { get; private set; }

    //Singleton
    private static CarPartsManager _Instance;
    public static CarPartsManager Instance
    {
        get
        {
            if (_Instance == null)
            {
                _Instance = FindObjectOfType<CarPartsManager>();
            }

            return _Instance;
        }
    }

    /// <summary>
    /// Initializes the CarPartsManager by parsing all the available parts
    /// </summary>
    /// <returns>Was the initalization succcessful?</returns>
    public bool Initialize()
    {
        return ParseConfiguration();
    }

    /// <summary>
    /// Parses the car parts configuration to obtain all the parts
    /// </summary>
    /// <returns>Was the parse successful?</returns>
    private bool ParseConfiguration()
    {
        try
        {
            //Let's load our XML and create our sub configuration objects
            TextAsset xmlText = (TextAsset)Resources.Load("Cars/CarParts");
            XDocument configXML = XDocument.Parse(xmlText.text);

            LowEndParts = new CarsClassParts();
            MediumEndParts = new CarsClassParts();
            HighEndParts = new CarsClassParts();

            //Let's try to parse all of our sub configurations, passing in the corresponding parent elements
            if (LowEndParts.Parse(configXML.Root.Element("LowEnd")))
            {
                if (MediumEndParts.Parse(configXML.Root.Element("MediumEnd")))
                {
                    if (HighEndParts.Parse(configXML.Root.Element("HighEnd")))
                    {
                        return true;    //Parsed everything successfully!
                    }

                    else
                    {
                        Debug.LogError("ERROR: Failed to parse high-end car parts. Perhaps the XML is malformed?");
                    }
                }

                else
                {
                    Debug.LogError("ERROR: Failed to parse medium-end car parts. Perhaps the XML is malformed?");
                }
            }

            else
            {
                Debug.LogError("ERROR: Failed to parse low-end car parts. Perhaps the XML is malformed?");
            }

            return false;   //We must have failed to parse one of the configurations
        }

        catch (Exception ex)
        {
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
